---
generated_at: 2026-02-02 11:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-Confluent Registry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `RegistryAvroFormatFactory.java` 84行目 - IDENTIFIER定義
- E-02: `RegistryAvroFormatFactory.java` 87-121行目 - createDecodingFormat
- E-03: `RegistryAvroFormatFactory.java` 124-161行目 - createEncodingFormat
- E-04: `RegistryAvroFormatFactory.java` 133-138行目 - subject必須チェック
- E-05: `RegistryAvroFormatFactory.java` 169-173行目 - requiredOptions（URL）
- E-06: `RegistryAvroFormatFactory.java` 210-245行目 - buildOptionalPropertiesMap
- E-07: `AvroConfluentFormatOptions.java` 31-37行目 - URL定義
- E-08: `AvroConfluentFormatOptions.java` 39-50行目 - SUBJECT定義
- E-09: `AvroConfluentFormatOptions.java` 52-62行目 - SCHEMA定義
- E-10: `AvroConfluentFormatOptions.java` 68-90行目 - SSL設定
- E-11: `AvroConfluentFormatOptions.java` 92-114行目 - 認証設定
- E-12: `ConfluentRegistryAvroDeserializationSchema.java` 42行目 - DEFAULT_IDENTITY_MAP_CAPACITY
- E-13: `ConfluentRegistryAvroDeserializationSchema.java` 124-133行目 - forGeneric
- E-14: `機能一覧.csv` 50行目 - Confluent Registry機能の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーマット識別子は "avro-confluent" | E-01 | ○ |
| C-02 | URL は必須オプション | E-05, E-07 | ○ |
| C-03 | シリアライズ時は subject 必須 | E-04 | ○ |
| C-04 | schema 未指定時はテーブルスキーマから自動生成 | E-02 (103-106行目), E-03 (145-148行目) | ○ |
| C-05 | デフォルト 1000 バージョンまでキャッシュ | E-12 | ○ |
| C-06 | SSL keystore/truststore 設定可能 | E-10 | ○ |
| C-07 | basic-auth 設定可能 | E-11 (92-102行目) | ○ |
| C-08 | bearer-auth 設定可能 | E-11 (104-114行目) | ○ |
| C-09 | ChangelogMode は insertOnly() | E-02 (117-118行目), E-03 (157-158行目) | ○ |
| C-10 | ProjectableDecodingFormat を実装 | E-02 (95行目) | ○ |
| C-11 | ConfluentRegistryAvroDeserializationSchema.forGeneric でデシリアライザ生成 | E-02 (110-111行目) | ○ |
| C-12 | ConfluentRegistryAvroSerializationSchema.forGeneric でシリアライザ生成 | E-03 (151-152行目) | ○ |
| C-13 | CachedSchemaCoderProvider でスキーマキャッシュ | E-13 (132行目) | ○ |
| C-14 | ValidationException でシリアライズ時 subject 未指定エラー | E-04 | ○ |
| C-15 | buildOptionalPropertiesMap で認証プロパティ構築 | E-06 | ○ |
| C-16 | PROPERTIES で追加プロパティを指定可能 | E-06 (214行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Confluent Wire Format の詳細説明が必要か確認
- [ ] Debezium Avro フォーマットの詳細説明が必要か確認
- [ ] スキーマ互換性チェックの詳細説明が必要か確認
